/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.impl;

import com.cisco.pt.UUID;
import java.util.Arrays;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UUIDImpl
implements UUID {
    private static Log logger = LogFactory.getLog(UUIDImpl.class);
    private static final String NONHEX_REGEX = "[^0-9a-f]";
    public static final int UUID_BYTES = 16;
    byte[] bytes = new byte[16];

    public UUIDImpl(byte[] newBytes) {
        this.setBytes(newBytes);
    }

    public UUIDImpl(String str) {
        if (str == null) {
            return;
        }
        try {
            String uuidStr = str.replaceAll(NONHEX_REGEX, "");
            this.setBytes(Hex.decodeHex((char[])uuidStr.toCharArray()));
        }
        catch (PatternSyntaxException pse) {
            logger.error((Object)pse.getMessage());
        }
        catch (DecoderException de) {
            logger.error((Object)("Error decoding UUID string: " + de.getMessage()));
        }
    }

    protected void setBytes(byte[] newBytes) {
        Arrays.fill(this.bytes, (byte)0);
        int offset = newBytes.length >= this.bytes.length ? 0 : this.bytes.length - newBytes.length;
        int limit = Math.min(this.bytes.length, newBytes.length);
        for (int i = 0; i < limit; ++i) {
            this.bytes[offset + i] = newBytes[i];
        }
    }

    public String toString() {
        return this.getDecoratedHexString();
    }

    public String getDecoratedHexString() {
        StringBuffer sb = new StringBuffer();
        char[] chars = Hex.encodeHex((byte[])this.bytes);
        if (chars.length == 32) {
            sb.append("{");
            sb.append(chars, 0, 8);
            sb.append('-');
            sb.append(chars, 8, 4);
            sb.append('-');
            sb.append(chars, 12, 4);
            sb.append('-');
            sb.append(chars, 16, 4);
            sb.append('-');
            sb.append(chars, 20, 12);
            sb.append("}");
        }
        return sb.toString();
    }

    public byte[] getByteArrayValue() {
        return this.bytes;
    }

    public static UUID makeRandom() {
        byte[] bytes = new byte[16];
        for (int i = 0; i < 16; ++i) {
            bytes[i] = (byte)(Math.random() * 255.0);
        }
        UUIDImpl uuid = new UUIDImpl(bytes);
        return uuid;
    }

    public boolean equals(UUID other) {
        byte[] otherbyte = other.getByteArrayValue();
        for (int i = 0; i < this.bytes.length; ++i) {
            if (this.bytes[i] == otherbyte[i]) continue;
            return false;
        }
        return true;
    }
}

